// ----------All Vanilla Mobs----------
const allVanillaMobs = {
    "minecraft:allay": "Allay",
    "minecraft:armadillo": "Armadillo",
    "minecraft:axolotl": "Axolotl",
    "minecraft:bat": "Bat",
    "minecraft:camel": "Camel",
    "minecraft:cat": "Cat",
    "minecraft:chicken": "Chicken",
    "minecraft:cod": "Cod",
    "minecraft:cow": "Cow",
    "minecraft:donkey": "Donkey",
    "minecraft:fox": "Fox",
    "minecraft:frog": "Frog",
    "minecraft:glow_squid": "Glow Squid",
    "minecraft:horse": "Horse",
    "minecraft:mooshroom": "Mooshroom",
    "minecraft:mule": "Mule",
    "minecraft:ocelot": "Ocelot",
    "minecraft:parrot": "Parrot",
    "minecraft:pig": "Pig",
    "minecraft:rabbit": "Rabbit",
    "minecraft:salmon": "Salmon",
    "minecraft:sheep": "Sheep",
    "minecraft:skeleton_horse": "Skeleton Horse",
    "minecraft:sniffer": "Sniffer",
    "minecraft:snow_golem": "Snow Golem",
    "minecraft:squid": "Squid",
    "minecraft:strider": "Strider",
    "minecraft:tadpole": "Tadpole",
    "minecraft:tropical_fish": "Tropical Fish",
    "minecraft:turtle": "Turtle",
    "minecraft:villager": "Villager",
    "minecraft:wandering_trader": "Wandering Trader",
    "minecraft:bee": "Bee",
    "minecraft:dolphin": "Dolphin",
    "minecraft:goat": "Goat",
    "minecraft:iron_golem": "Iron Golem",
    "minecraft:llama": "Llama",
    "minecraft:polar_bear": "Polar Bear",
    "minecraft:trader_llama": "Trader Llama",
    "minecraft:wolf": "Wolf",
    "minecraft:zombified_piglin": "Zombified Piglin",
    "minecraft:piglin": "Piglin",
    "minecraft:zombie": "Zombie",
    "minecraft:zombie_villager": "Zombie Villager",
    "minecraft:husk": "Husk",
    "minecraft:drowned": "Drowned",
    "minecraft:skeleton": "Skeleton",
    "minecraft:stray": "Stray",
    "minecraft:creeper": "Creeper",
    "minecraft:spider": "Spider",
    "minecraft:cave_spider": "Cave Spider",
    "minecraft:enderman": "Enderman",
    "minecraft:slime": "Slime",
    "minecraft:phantom": "Phantom",
    "minecraft:witch": "Witch",
    "minecraft:silverfish": "Silverfish",
    "minecraft:endermite": "Endermite",
    "minecraft:guardian": "Guardian",
    "minecraft:elder_guardian": "Elder Guardian",
    "minecraft:ravager": "Ravager",
    "minecraft:vex": "Vex",
    "minecraft:evoker": "Evoker",
    "minecraft:vindicator": "Vindicator",
    "minecraft:pillager": "Pillager",
    "minecraft:blaze": "Blaze",
    "minecraft:wither_skeleton": "Wither Skeleton",
    "minecraft:ghast": "Ghast",
    "minecraft:magma_cube": "Magma Cube",
    "minecraft:piglin_brute": "Piglin Brute",
    "minecraft:hoglin": "Hoglin",
    "minecraft:zoglin": "Zoglin",
    "minecraft:shulker": "Shulker",
    "minecraft:ender_dragon": "Ender Dragon",
    "minecraft:wither": "Wither",
    "minecraft:warden": "Warden"
};

// ----------Passive Mobs----------
const passiveMobs = {
    "minecraft:allay": "Allay",
    "minecraft:armadillo": "Armadillo",
    "minecraft:axolotl": "Axolotl",
    "minecraft:bat": "Bat",
    "minecraft:camel": "Camel",
    "minecraft:cat": "Cat",
    "minecraft:chicken": "Chicken",
    "minecraft:cod": "Cod",
    "minecraft:cow": "Cow",
    "minecraft:donkey": "Donkey",
    "minecraft:fox": "Fox",
    "minecraft:frog": "Frog",
    "minecraft:glow_squid": "Glow Squid",
    "minecraft:horse": "Horse",
    "minecraft:mooshroom": "Mooshroom",
    "minecraft:mule": "Mule",
    "minecraft:ocelot": "Ocelot",
    "minecraft:parrot": "Parrot",
    "minecraft:pig": "Pig",
    "minecraft:rabbit": "Rabbit",
    "minecraft:salmon": "Salmon",
    "minecraft:sheep": "Sheep",
    "minecraft:skeleton_horse": "Skeleton Horse",
    "minecraft:sniffer": "Sniffer",
    "minecraft:snow_golem": "Snow Golem",
    "minecraft:squid": "Squid",
    "minecraft:strider": "Strider",
    "minecraft:tadpole": "Tadpole",
    "minecraft:tropical_fish": "Tropical Fish",
    "minecraft:turtle": "Turtle",
    "minecraft:villager": "Villager",
    "minecraft:wandering_trader": "Wandering Trader"
};

// ----------Neutral Mobs----------
const neutralMobs = {
  "minecraft:bee": "Bee",
  "minecraft:cave_spider": "Cave Spider",
  "minecraft:dolphin": "Dolphin",
  "minecraft:enderman": "Enderman",
  "minecraft:goat": "Goat",
  "minecraft:iron_golem": "Iron Golem",
  "minecraft:llama": "Llama",
  "minecraft:polar_bear": "Polar Bear",
  "minecraft:spider": "Spider",
  "minecraft:trader_llama": "Trader Llama",
  "minecraft:wolf": "Wolf",
  "minecraft:zombified_piglin": "Zombified Piglin",
  "minecraft:piglin": "Piglin"
};

// ----------Monsters----------
const allMonsters = {
    "minecraft:zombie": "Zombie",
    "minecraft:zombie_villager": "Zombie Villager",
    "minecraft:husk": "Husk",
    "minecraft:drowned": "Drowned",
    "minecraft:skeleton": "Skeleton",
    "minecraft:stray": "Stray",
    "minecraft:creeper": "Creeper",
    "minecraft:spider": "Spider",
    "minecraft:cave_spider": "Cave Spider",
    "minecraft:enderman": "Enderman",
    "minecraft:slime": "Slime",
    "minecraft:phantom": "Phantom",
    "minecraft:witch": "Witch",
    "minecraft:silverfish": "Silverfish",
    "minecraft:endermite": "Endermite",
    "minecraft:guardian": "Guardian",
    "minecraft:elder_guardian": "Elder Guardian",
    "minecraft:ravager": "Ravager",
    "minecraft:vex": "Vex",
    "minecraft:evoker": "Evoker",
    "minecraft:vindicator": "Vindicator",
    "minecraft:pillager": "Pillager",
    "minecraft:blaze": "Blaze",
    "minecraft:wither_skeleton": "Wither Skeleton",
    "minecraft:ghast": "Ghast",
    "minecraft:magma_cube": "Magma Cube",
    "minecraft:piglin_brute": "Piglin Brute",
    "minecraft:hoglin": "Hoglin",
    "minecraft:zoglin": "Zoglin",
    "minecraft:shulker": "Shulker",
    "minecraft:ender_dragon": "Ender Dragon",
    "minecraft:wither": "Wither",
    "minecraft:warden": "Warden"
};

const overworldMonsters = {
    "minecraft:zombie": "Zombie",
    "minecraft:zombie_villager": "Zombie Villager",
    "minecraft:husk": "Husk",
    "minecraft:drowned": "Drowned",
    "minecraft:skeleton": "Skeleton",
    "minecraft:stray": "Stray",
    "minecraft:creeper": "Creeper",
    "minecraft:spider": "Spider",
    "minecraft:cave_spider": "Cave Spider",
    "minecraft:enderman": "Enderman",
    "minecraft:slime": "Slime",
    "minecraft:phantom": "Phantom",
    "minecraft:witch": "Witch",
    "minecraft:silverfish": "Silverfish",
    "minecraft:endermite": "Endermite",
    "minecraft:guardian": "Guardian",
    "minecraft:elder_guardian": "Elder Guardian",
    "minecraft:ravager": "Ravager",
    "minecraft:vex": "Vex",
    "minecraft:evoker": "Evoker",
    "minecraft:vindicator": "Vindicator",
    "minecraft:pillager": "Pillager",
    "minecraft:breeze": "Breeze",
    "minecraft:bogged": "Bogged",
    "minecraft:creaking": "Creaking"
};

const netherMonsters = {
    "minecraft:blaze": "Blaze",
    "minecraft:wither_skeleton": "Wither Skeleton",
    "minecraft:ghast": "Ghast",
    "minecraft:magma_cube": "Magma Cube",
    "minecraft:piglin_brute": "Piglin Brute",
    "minecraft:hoglin": "Hoglin",
    "minecraft:zoglin": "Zoglin"
};
const endMonsters = {
    "minecraft:shulker": "Shulker"
};
const bossMonsters = {
    "minecraft:ender_dragon": "Ender Dragon",
    "minecraft:wither": "Wither",
    "minecraft:warden": "Warden"
};

/**
 * Looks for the mobs identifier by matching the mobs name with the name.
 * @param {string} name - The name of the mob that we are using.
 * @returns {Entity} Returns the entity's identifier from vanilla mobs.
 */
export function getMobIdFromName(name) {
    for (const [code, mobName] of Object.entries(allVanillaMobs)) {
        if (mobName.toLowerCase() === name.toLowerCase()) {
            return code;
        }
    }
    return;
}

// Exports every list here
export {
    allVanillaMobs,
    passiveMobs, // Passive
    neutralMobs, // Neutral
    allMonsters, overworldMonsters, netherMonsters, endMonsters, bossMonsters // Hostile
};